/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import technology.rocketjump.undermount.ui.actions.ButtonAction;
import technology.rocketjump.undermount.ui.fonts.GameFont;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;

public class IconButton
extends Table {
    public static final int ICON_PX_WIDTH_HEIGHT = 64;
    public static final float MARGIN = 2.0f;
    public static final float HIGHLIGHT_CHANGE_SPEED = 2.0f;
    public static final float DEFAULT_TEXT_HEIGHT = 24.0f;
    public static final float TEXT_MARGIN = 2.0f;
    private final GameFont defaultFont;
    private final String i18nKey;
    private GameFont currentFont;
    private final ButtonStyle style;
    private Image currentIcon;
    private Label currentLabel;
    private Color defaultBackgroundColor = Color.BLACK;
    private Color defaultForegroundColor = Color.GREEN;
    private Color currentBackgroundColor = new Color();
    private Color currentForegroundColor = new Color();
    private NinePatchDrawable buttonNinepatch;
    private ButtonAction action;
    private boolean isHighlighted;
    private float highlight = 0.0f;

    public IconButton(GameFont font, String i18nKey) {
        this(font, i18nKey, ButtonStyle.DEFAULT);
    }

    public IconButton(GameFont font, String i18nKey, ButtonStyle style) {
        this.defaultFont = font;
        this.currentFont = font;
        this.style = style;
        this.i18nKey = i18nKey;
        this.setTouchable(Touchable.enabled);
        this.addListener(new IconButtonClickListener(this));
    }

    public void setLabelText(String labelText) {
        labelText = this.wrap(labelText);
        this.currentFont = this.defaultFont;
        this.resetLabel(labelText);
        this.trimLabel(labelText);
        this.resetChildren();
    }

    private String wrap(String labelText) {
        if (this.style.equals((Object)ButtonStyle.LARGE) && labelText.indexOf(10) == -1 && labelText.indexOf(32) != -1) {
            int indexOfMiddleSpace = -1;
            int indexOfMiddle = labelText.length() / 2;
            int lastDistanceToMiddle = labelText.length();
            for (int cursor = 0; cursor < labelText.length(); ++cursor) {
                int distanceToMiddle;
                if (labelText.charAt(cursor) != ' ' || (distanceToMiddle = Math.abs(indexOfMiddle - cursor)) >= lastDistanceToMiddle) continue;
                indexOfMiddleSpace = cursor;
                lastDistanceToMiddle = distanceToMiddle;
            }
            if (indexOfMiddleSpace != -1) {
                return labelText.substring(0, indexOfMiddleSpace) + "\n" + labelText.substring(indexOfMiddleSpace + 1, labelText.length());
            }
        }
        return labelText;
    }

    private void resetLabel(String labelText) {
        Label.LabelStyle labelStyle = new Label.LabelStyle(this.currentFont.getBitmapFont(), Color.WHITE);
        this.currentLabel = new Label((CharSequence)labelText, labelStyle);
        if (this.currentLabel.getPrefWidth() > this.style.MAX_WIDTH && this.currentFont.getSmaller() != null) {
            this.currentFont = this.currentFont.getSmaller();
            this.resetLabel(labelText);
        }
    }

    private void trimLabel(String labelText) {
        float maxAllowedWidth = this.style.MAX_WIDTH;
        float currentLabelWidth = this.currentLabel.getPrefWidth();
        while (currentLabelWidth > maxAllowedWidth) {
            labelText = this.trimLastCharOfEachLine(labelText);
            Label.LabelStyle labelStyle = new Label.LabelStyle(this.currentFont.getBitmapFont(), Color.WHITE);
            this.currentLabel = new Label((CharSequence)labelText, labelStyle);
            currentLabelWidth = this.currentLabel.getPrefWidth();
        }
    }

    private String trimLastCharOfEachLine(String text) {
        text = text.replaceAll(".\\\n", "\n");
        return text.substring(0, text.length() - 1);
    }

    private void resetChildren() {
        this.clearChildren();
        if (this.currentIcon != null) {
            Cell<Image> cell = this.add(this.currentIcon);
            if (this.style.equals((Object)ButtonStyle.LARGE)) {
                cell.padLeft(32.0f).padRight(32.0f);
            }
            this.row();
        }
        if (this.currentLabel != null) {
            this.add(this.currentLabel).height(this.style.LABEL_HEIGHT);
            this.row();
        }
        if (this.style.equals((Object)ButtonStyle.EXTRA_WIDE)) {
            this.add(new Table()).width(300.0f);
        }
    }

    public void setIconSprite(Sprite iconSprite) {
        this.currentIcon = new Image(iconSprite);
        this.resetChildren();
    }

    @Override
    public void act(float delta) {
        if (this.isHighlighted && this.highlight < 1.0f) {
            this.highlight += 2.0f * delta;
        } else if (!this.isHighlighted && this.highlight > 0.0f) {
            this.highlight -= 2.0f * delta;
        }
        if (this.highlight <= 0.0f) {
            this.currentBackgroundColor = this.defaultBackgroundColor.cpy();
            this.currentForegroundColor = this.defaultForegroundColor.cpy();
        } else if (this.highlight >= 1.0f) {
            this.currentBackgroundColor = this.defaultForegroundColor.cpy();
            this.currentForegroundColor = this.defaultBackgroundColor.cpy();
        } else {
            this.currentForegroundColor.r = this.defaultBackgroundColor.r * this.highlight + this.defaultForegroundColor.r * (1.0f - this.highlight);
            this.currentForegroundColor.g = this.defaultBackgroundColor.g * this.highlight + this.defaultForegroundColor.g * (1.0f - this.highlight);
            this.currentForegroundColor.b = this.defaultBackgroundColor.b * this.highlight + this.defaultForegroundColor.b * (1.0f - this.highlight);
            this.currentBackgroundColor.r = this.defaultForegroundColor.r * this.highlight + this.defaultBackgroundColor.r * (1.0f - this.highlight);
            this.currentBackgroundColor.g = this.defaultForegroundColor.g * this.highlight + this.defaultBackgroundColor.g * (1.0f - this.highlight);
            this.currentBackgroundColor.b = this.defaultForegroundColor.b * this.highlight + this.defaultBackgroundColor.b * (1.0f - this.highlight);
        }
        if (this.currentIcon != null) {
            this.currentIcon.setColor(this.currentForegroundColor);
        }
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        if (this.getBackground() == null) {
            return;
        }
        Color color = this.currentBackgroundColor;
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.getBackground().draw(batch, x, y, this.getWidth(), this.getHeight());
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.defaultBackgroundColor = backgroundColor.cpy();
    }

    public Color getBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.defaultForegroundColor = foregroundColor.cpy();
    }

    public Color getForegroundColor() {
        return this.defaultForegroundColor;
    }

    public void setButtonNinepatch(NinePatch ninePatch) {
        this.buttonNinepatch = new NinePatchDrawable(ninePatch);
        this.setBackground(this.buttonNinepatch);
    }

    public NinePatchDrawable getButtonNinepatch() {
        return this.buttonNinepatch;
    }

    public void setAction(ButtonAction action) {
        this.action = action;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    protected static class IconButtonClickListener
    extends ClickListener {
        protected final IconButton parent;

        public IconButtonClickListener(IconButton parent) {
            this.parent = parent;
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            if (this.parent.action == null) {
                System.out.println("No action set for button " + this.parent.currentLabel);
            } else {
                this.parent.action.onClick();
            }
        }

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
            this.parent.isHighlighted = true;
        }

        @Override
        public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
            this.parent.isHighlighted = false;
        }
    }
}

